// 19/11/2018
//
// Genus 2

load "FiberProductsDataadiconlymaximal.m";


Genus2Unknown:= [];
Genus2Rank0_with:= [];
Genus2Rank0_without:= [];
Genus2Rank1_with:= [];
Genus2Rank1_without:= [];
Genus2RankAtleast2_without:=[];

jCM:={0,1728,2^4*3^3*5^3,2^3*3^3*11^3,-3^3*5^3,3^3*5^3*17^3,2^6*5^3,-2^(15)*3*5^3,-2^(15),-2^(15)*3^3,-2^(18)*3^3*5^3,-2^(15)*3^3*5^3*11^3,-2^(18)*3^3*5^3*23^3*29^3};


for k in CurvesByGenus[2] do
	print k;
	C := FiberProducts[k]`curve;
	_,H1,mp1 := IsHyperelliptic(C);
	H,mp2 := SimplifiedModel(H1);
	f<x>,g<x> := HyperellipticPolynomials(H);
	J := Jacobian(H);
	rJ:=RankBound(J);
	case rJ:
		when 0: print "####### RANK 0 #######";
			PtsH := Chabauty0(J); 
//
		PtsC := { };
		PHI := mp1*mp2;
		for P in PtsH do
			PtsC := {pt : pt in RationalPoints(P @@ PHI)} join PtsC;
		end for;
		j1 := Groups[k[1]]`jmap;
		j2 := Groups[k[2]]`jmap;
		
		Pts:=[pt : pt in PtsC | (Evaluate(Denominator(j1),pt[1]) ne 0) and (Evaluate(Denominator(j2),pt[2]) ne 0) and (pt[3] ne 0)];
		assert &and{Evaluate(j1,pt[1]/pt[3]) eq  Evaluate(j2,pt[2]/pt[3]) : pt in Pts};	
		js:={Evaluate(j1,pt[1]/pt[3]): pt in Pts};
			
		Ptsj:=<>;
		for pt in Pts do
				jpt:=Evaluate(j1,pt[1]/pt[3]);
				ptt:=[pt[1]/pt[3],pt[2]/pt[3]];
				printf "%o -> %o\n",pt,jpt;
				Ptsj:=Append(Ptsj,<ptt,jpt>);
		end for;
		printf "\n ---------------------> y^2=%o ----> %o - %o\n",f, js,js diff jCM;	
		fprintf "output_g2_RP.txt","<[\"%o,%o\"],%o,%o,%o,%o>,\n",k[1],k[2],rJ,f,Ptsj,js diff jCM;
		jsnoCM:=(js diff jCM);
		if #jsnoCM ne 0 then
			Append(~Genus2Rank0_with,k);
		  else
		    Append(~Genus2Rank0_without,k);
		end if;
        when 1:  print "####### RANK 1 #######";
    		PTS := PointsAtInfinity(H);
    		case #PTS:
    			when 2:  				
    				P := PTS[1] - PTS[2];
				when 1:
					PP:=PointSearch(C,1000); 
					P:=[PTS[1]-mp1(q) : q in [qq : qq in PP | qq[3] ne 0] | Order(PTS[1]-mp1(q)) eq 0];
					if #P eq 0 then
						Append(~Genus2Unknown,k);	
						printf "@@@@@ Increase the bound: %o @@@@@\n", k;
						break;	  
					  else
					    P:=P[1];
					end if;
				else
					S:=[q : q in BadPrimes(H) | not IsLocallySolvable(H,q)];
					if #S ne 0 then
			 			Append(~Genus2Rank1_without,k);
           			  else
           				Append(~Genus2Unknown,k);	
           				break;	  
					end if;
			end case;
			assert Order(P) eq 0;
    		PtsH := Chabauty(P);
//    		
	    	PtsC := { };
			PHI := mp1*mp2;
			for P in PtsH do
				PtsC := {pt : pt in RationalPoints(P @@ PHI)} join PtsC;
			end for;
			j1 := Groups[k[1]]`jmap;
			j2 := Groups[k[2]]`jmap;
			Pts:=[pt : pt in PtsC | (Evaluate(Denominator(j1),pt[1]) ne 0) and (Evaluate(Denominator(j2),pt[2]) ne 0) and (pt[3] ne 0)];
			assert &and{Evaluate(j1,pt[1]/pt[3]) eq  Evaluate(j2,pt[2]/pt[3]) : pt in Pts};	
			js:={Evaluate(j1,pt[1]/pt[3]): pt in Pts};
			
			Ptsj:=<>;
			for pt in Pts do
				jpt:=Evaluate(j1,pt[1]/pt[3]);
				ptt:=[pt[1]/pt[3],pt[2]/pt[3]];
				printf "%o -> %o\n",pt,jpt;
				Ptsj:=Append(Ptsj,<ptt,jpt>);
			end for;
			printf "\n ---------------------> y^2=%o ----> %o - %o\n",f, js,js diff jCM;	
			fprintf "output_g2_RP.txt","<[\"%o,%o\"],%o,%o,%o,%o>,\n",k[1],k[2],rJ,f,Ptsj,js diff jCM;
			jsnoCM:=(js diff jCM);
			if #jsnoCM ne 0 then
				Append(~Genus2Rank1_with,k);
		  	  else
		    	Append(~Genus2Rank1_without,k);
			end if;
//
		  else print "####### RANK > 1 #######";
			S:=[q : q in BadPrimes(H) | not IsLocallySolvable(H,q)];
			if #S ne 0 then
				 Append(~Genus2RankAtleast2_without,k);
     	 		 printf "\n ---------------------> y^2=%o ----> Non Locally %o - %o\n",f,S, {};	
				 fprintf "output_g2_RP.txt","<[\"%o,%o\"],%o,%o,%o,%o>,\n",k[1],k[2],rJ,f,S,{};
           	   else
           		Append(~Genus2Unknown,k);	
          		fprintf "output_g2_RP.txt","<[\"%o,%o\"],%o,%o,\"TODO\",\"TODO\">,\n",k[1],k[2],rJ,f;
          		printf "\n ---------------------> y^2=%o ----> TODO \n",f;	
         	end if;
	end case;
//end if;
end for;


/////////////////////////////////////////////////////////
procedure LATEX(file,name_list,list,text)

	fprintf file, "\n//// %o\n %o := [\n",text,name_list;
	for i in [1..#list] do
		k := list[i];
		if i ne #list then
			fprintf file, "[\"%o\",\"%o\"],\n", k[1],k[2];
		end if;
		if i eq #list then
			fprintf file, "[\"%o\",\"%o\"]\n", k[1],k[2];
		end if;		
	end for;
	fprintf file, "];\n";
end procedure;


LATEX("output_genus2.txt","Genus2Rank0_with",Genus2Rank0_with,"Genus 2 with rank 0 and non-CM j-invariants:");
LATEX("output_genus2.txt","Genus2Rank0_without",Genus2Rank0_without,"Genus 2 with rank 0 and without non-CM j-invariants:");
LATEX("output_genus2.txt","Genus2Rank1_with",Genus2Rank1_with,"Genus 2 with rank 1 and non-CM j-invariants:");
LATEX("output_genus2.txt","Genus2Rank1_without",Genus2Rank1_without,"Genus 2 with rank 1 and without non-CM j-invariants:");
LATEX("output_genus2.txt","Genus2RankAtleast2_without",Genus2RankAtleast2_without,"Genus 2 Non Locally Solvable:");
LATEX("output_genus2.txt","Genus2Unknown",Genus2Unknown,"Genus 2 TODO (UnSolved):");


/*
fprintf "output_genus2.txt", "//Genus 2 with rank 0 and non-CM j-invariants:\n Genus2Rank0_with:=%o;\n\n",Genus2Rank0_with;
fprintf "output_genus2.txt", "//Genus 2 with rank 0 and without non-CM j-invariants:\n Genus2Rank0_without:=%o;\n\n",Genus2Rank0_without;
fprintf "output_genus2.txt", "//Genus 2 with rank 1 and non-CM j-invariants:\n Genus2Rank1_with:=%o;\n\n",Genus2Rank1_with;
fprintf "output_genus2.txt", "//Genus 2 with rank 1 and without non-CM j-invariants:\n Genus2Rank1_without:=%o;\n\n",Genus2Rank1_without;
fprintf "output_genus2.txt", "//Genus 2 Non Locally Solvable:\n Genus2RankAtleast2_without:=%o;\n\n",Genus2RankAtleast2_without;                                                  
fprintf "output_genus2.txt", "//Genus 2 TODO (UnSolved):\n Genus2Unknown:=%o;\n\n",Genus2Unknown;
*/


